<!doctype html>
<html class="no-js" lang="en">

<head>
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="description" content="">

  <!-- Site Title -->
  <title>ASV</title>

  <!-- Place favicon.ico in the root directory -->
  <link rel="shortcut icon" type="image/x-icon" href="assets/images/fav.png">

  <!-- CSS here -->
  <link rel="stylesheet" href="assets/css/bootstrap.min.css">
  <link rel="stylesheet" href="assets/css/font-awesome-pro.min.css">
  <link rel="stylesheet" href="assets/css/animate.min.css">
  <link rel="stylesheet" href="assets/css/bexon-icons.css">
  <link rel="stylesheet" href="assets/css/nice-select.css">
  <link rel="stylesheet" href="assets/css/swiper.min.css">
  <link rel="stylesheet" href="assets/css/venobox.min.css">
  <link rel="stylesheet" href="assets/css/odometer-theme-default.css">
  <link rel="stylesheet" href="assets/css/meanmenu.css">
  <link rel="stylesheet" href="assets/css/main.css">
</head>

<body>
  <div class="body-overlay"></div>

  <!-- Preloader Start -->
  <div class="preloader">
    <div class="loading-container">
      <div class="loading"></div>
      <div id="loading-icon"><img src="assets/images/logos/logo_loading.png" alt=""></div>
    </div>
  </div>
  <!-- Preloader end -->

  <!-- back to top start -->
  <div class="back-to-top-wrapper">
    <button id="back_to_top" type="button" class="back-to-top-btn">
      <span><i class="tji-arrow-up-long"></i></span>
    </button>
  </div>
  <!-- back to top end -->

  <!-- start: Header Area -->
  <?php include("header.php"); 
  ?>
  <!-- end: Header Area -->

  <main id="primary" class="site-main">
    <!-- start: Breadcrumb Section -->
    <section class="tj-page-header section-gap-x" data-bg-image="assets/images/bg/pheader-bg.webp">
      <div class="container">
        <div class="row">
          <div class="col-lg-12">
            <div class="tj-page-header-content text-center">
              <div class="tj-page-link">
                <span><i class="tji-home"></i></span>
                <span>
                  <a href="index.php">Home</a>
                </span>
                <span><i class="tji-arrow-right"></i></span>
                <span>
                  <span>Real Estate</span>
                </span>
                <span><i class="tji-arrow-right"></i></span>
                <span>
                  <span>Investment Consultation</span>
                </span>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="page-header-overlay" data-bg-image="assets/images/shape/pheader-overlay.webp"></div>
    </section>
    <!-- end: Breadcrumb Section -->

    <!-- start: Blog Section -->
    <section class="tj-blog-section section-gap">
      <div class="container">
        <div class="row row-gap-5">
          <div class="col-lg-12">
            <div class="post-details-wrapper">
              <h3 class="title title-anim">Strategic Advisory for Smarter Property Decisions</h3>
              <div class="blog-text">
                <p class="wow fadeInUp" data-wow-delay=".3s">our Real Estate Investment Consultation services are designed to help investors make informed, secure, and high-return property investment decisions. We provide expert guidance across residential, commercial, and land investments by combining market intelligence, financial analysis, and regulatory understanding.
                </p>
                <p class="wow fadeInUp" data-wow-delay=".3s">We provide tailored consultation across multiple real estate asset categories like Residential investments, Commercial investments, Land investments, Income-generating properties.</p>

                <div class="images-wrap">
                  <div class="row">
                    <div class="col-sm-4">
                      <div class="image-box wow fadeInUp" data-wow-delay=".3s">
                        <img src="assets/images/service/res.jpg" alt="Image">
                      </div>
                    </div>
                    <div class="col-sm-4">
                      <div class="image-box wow fadeInUp" data-wow-delay=".5s">
                        <img src="assets/images/service/com.jpg" alt="Image">
                      </div>
                    </div>
                    <div class="col-sm-4">
                      <div class="image-box wow fadeInUp" data-wow-delay=".5s">
                        <img src="assets/images/service/plot.jpg" alt="Image">
                      </div>
                    </div>
                  </div>
                </div>
                <h3 class="wow fadeInUp" data-wow-delay=".3s">Investment Strategy & Planning</h3>
                <p class="wow fadeInUp" data-wow-delay=".3s">We conduct comprehensive market research to identify high-potential investment opportunities across emerging and established micro-markets.Begin with a deep understanding of your investment objectives—capital appreciation, rental income, portfolio diversification, or long-term asset creation.</p>
                <p>Strategic services include:</p>
                <ul class="wow fadeInUp" data-wow-delay=".3s">
                  <li><span><i class="tji-check"></i></span>Investment goal assessment</li>
                  <li><span><i class="tji-check"></i></span>Short-term vs long-term planning</li>
                  <li><span><i class="tji-check"></i></span>Budget & risk profiling</li>
                  <li><span><i class="tji-check"></i></span>Asset allocation strategy</li>
                </ul>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- end: Blog Section -->

    <!-- start: Cta Section --
    <section class="tj-cta-section">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <div class="cta-area">
              <div class="cta-content">
                <h2 class="title title-anim">Let’s Build Future Together.</h2>
                <div class="cta-btn wow fadeInUp" data-wow-delay=".6s">
                  <a class="tj-primary-btn btn-dark" href="contact.php">
                    <span class="btn-text"><span>Get Started Now</span></span>
                    <span class="btn-icon"><i class="tji-arrow-right-long"></i></span>
                  </a>
                </div>
              </div>
              <div class="cta-img">
                <img src="assets/images/cta/cta-bg.webp" alt="">
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!- end: Cta Section -->
  </main>

  <!-- start: Footer Section -->
  <?php include("footer.php"); 
  ?>
  <!-- end: Footer Section -->

  <!-- JS here -->
  <script src="assets/js/jquery.min.js"></script>
  <script src="assets/js/bootstrap.bundle.min.js"></script>

  <script src="assets/js/gsap.min.js"></script>
  <script src="assets/js/gsap-scroll-to-plugin.min.js"></script>
  <script src="assets/js/gsap-scroll-trigger.min.js"></script>
  <script src="assets/js/gsap-split-text.min.js"></script>
  <script src="assets/js/smooth-scroll.min.js"></script>

  <script src="assets/js/jquery.nice-select.min.js"></script>
  <script src="assets/js/swiper.min.js"></script>
  <script src="assets/js/odometer.min.js"></script>
  <script src="assets/js/venobox.min.js"></script>
  <script src="assets/js/appear.min.js"></script>
  <script src="assets/js/wow.min.js"></script>
  <script src="assets/js/meanmenu.js"></script>
  <script src="assets/js/main.js"></script>
</body>
</html>