<!doctype html>
<html class="no-js" lang="en">

<head>
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="description" content="">

  <!-- Site Title -->
  <title>ASV</title>

  <!-- Place favicon.ico in the root directory -->
  <link rel="shortcut icon" type="image/x-icon" href="assets/images/fav.png">

  <!-- CSS here -->
  <link rel="stylesheet" href="assets/css/bootstrap.min.css">
  <link rel="stylesheet" href="assets/css/font-awesome-pro.min.css">
  <link rel="stylesheet" href="assets/css/animate.min.css">
  <link rel="stylesheet" href="assets/css/bexon-icons.css">
  <link rel="stylesheet" href="assets/css/nice-select.css">
  <link rel="stylesheet" href="assets/css/swiper.min.css">
  <link rel="stylesheet" href="assets/css/venobox.min.css">
  <link rel="stylesheet" href="assets/css/odometer-theme-default.css">
  <link rel="stylesheet" href="assets/css/meanmenu.css">
  <link rel="stylesheet" href="assets/css/main.css">
</head>

<body>
  <div class="body-overlay"></div>

  <!-- Preloader Start -->
  <div class="preloader">
    <div class="loading-container">
      <div class="loading"></div>
      <div id="loading-icon"><img src="assets/images/logos/logo_loading.png" alt=""></div>
    </div>
  </div>
  <!-- Preloader end -->

  <!-- back to top start -->
  <div class="back-to-top-wrapper">
    <button id="back_to_top" type="button" class="back-to-top-btn">
      <span><i class="tji-arrow-up-long"></i></span>
    </button>
  </div>
  <!-- back to top end -->

  <!-- start: Header Area -->
  <?php include("header.php"); 
  ?>
  <!-- end: Header Area -->
  <main id="primary" class="site-main">

    <!-- start: Breadcrumb Section -->
    <section class="tj-page-header section-gap-x" data-bg-image="assets/images/bg/pheader-bg.webp">
      <div class="container">
        <div class="row">
          <div class="col-lg-12">
            <div class="tj-page-header-content text-center">
              <div class="tj-page-link">
                <span><i class="tji-home"></i></span>
                <span>
                  <a href="index.php">Home</a>
                </span>
                <span><i class="tji-arrow-right"></i></span>
                <span>
                  <span>About Us</span>
                </span>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="page-header-overlay" data-bg-image="assets/images/shape/pheader-overlay.webp"></div>
    </section>
    <!-- end: Breadcrumb Section -->

    <!-- start: Choose Section --
    <section id="choose" class="tj-choose-section section-gap">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <div class="sec-heading-wrap">
              <span class="sub-title wow fadeInUp" data-wow-delay=".3s"><i class="tji-box"></i>Choose the Best</span>
              <div class="heading-wrap-content">
                <div class="sec-heading">
                  <h2 class="sec-title title-anim">Empowering Business with <span>Expertise.</span></h2>
                </div>
                <div class="btn-wrap wow fadeInUp" data-wow-delay=".6s">
                  <a class="tj-primary-btn" href="contact.php">
                    <span class="btn-text"><span>Request a Call</span></span>
                    <span class="btn-icon"><i class="tji-arrow-right-long"></i></span>
                  </a>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="row row-gap-4 rightSwipeWrap">
          <div class="col-lg-4">
            <div class="choose-box right-swipe">
              <div class="choose-content">
                <div class="choose-icon">
                  <i class="tji-innovative"></i>
                </div>
                <h4 class="title">Innovative Solutions</h4>
                <p class="desc">We stay ahead of the curve, leveraging cutting-edge technologies and strategies to keep
                  you competitive in a marketplace.</p>
              </div>
            </div>
          </div>
          <div class="col-lg-4">
            <div class="choose-box right-swipe">
              <div class="choose-content">
                <div class="choose-icon">
                  <i class="tji-award"></i>
                </div>
                <h4 class="title">Award-Winning Expertise</h4>
                <p class="desc">Recognized by industry leaders, our award-winning team has a proven record of delivering
                  excellence across projects.</p>
              </div>
            </div>
          </div>
          <div class="col-lg-4">
            <div class="choose-box right-swipe">
              <div class="choose-content">
                <div class="choose-icon">
                  <i class="tji-support"></i>
                </div>
                <h4 class="title">Dedicated Support</h4>
                <p class="desc">Our team is always available to address your concerns, providing quick and effective
                  solution to keep your business.</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!- end: Choose Section -->
<section class="tj-blog-section section-gap">
      <div class="container">
        <div class="row row-gap-5">
          <div class="col-lg-12">
            <div class="post-details-wrapper">
              <h3 class="title title-anim">Elevating Businesses Through a Decade of Trusted Expertise</h3>
              <div class="blog-text">
                <p class="wow fadeInUp" data-wow-delay=".3s" style="text-align: justify;">Arkriyo Sampad Ventures is a diversified business enterprise driven by strategy, innovation, and long-term value creation. We operate across multiple sectors—Information Technology, Real Estate Construction, Investment Consultation, and Content Marketing—offering integrated solutions that empower businesses, investors, and brands to grow with confidence.
                </p>
                <p class="wow fadeInUp" data-wow-delay=".3s" style="text-align: justify;">With a strong foundation built on industry knowledge and practical execution, we focus on delivering solutions that are reliable, scalable, and result-oriented. Our multidisciplinary approach allows us to combine technology, infrastructure, financial insight, and creative communication under one unified vision.</p>
                <p class="wow fadeInUp" data-wow-delay=".3s" style="text-align: justify;">At Arkriyo Sampad Ventures, we don’t just deliver services—we build partnerships, create value, and contribute to sustainable growth across industries.</p>
              </div>
            </div>
          </div>
        </div>
      </div>
   
    <!-- start: About Section -->
    <section class="tj-about-section section-gap">
      <div class="container">
        <div class="row">
          <div class="col-xl-6 col-lg-6 order-lg-1 order-2">
            <div class="about-img-area style-2 wow fadeInLeft" data-wow-delay=".3s">
              <div class="about-img">
                <img src="assets/images/about/about-5.webp" alt="">
              </div>
            </div>
          </div>
          <div class="col-xl-6 col-lg-6 order-lg-2 order-1">
            <div class="about-content-area">
              <div class="sec-heading">
                <!--<span class="sub-title wow fadeInUp" data-wow-delay=".3s"><i class="tji-box"></i>Get to Know Us</span>-->
                <!--<h3 class="sec-title title-anim" style="background-color: #282828; color: #fecd0e;">The Principles That Define Us.
                </h3>-->
              </div>
            </div>
            <div class="about-bottom-area">
              <div class="mission-vision-box wow fadeInLeft" data-wow-delay=".5s">
                <h4 class="title">Our Mission</h4>
                <p class="desc">To deliver integrated, reliable, and forward-thinking solutions
                </p>
                <ul class="list-items">
                  <li><i class="tji-list"></i>Scalable Solutions</li>
                  <li><i class="tji-list"></i>Upholding Transparency & Professional Integrity</li>
                  <li><i class="tji-list"></i>Creating Measurable Value for Ventures</li>
                </ul>
              </div>
              <div class="mission-vision-box wow fadeInRight" data-wow-delay=".5s">
                <h4 class="title">Our Vision</h4>
                <p class="desc" style="text-align: justify;">To become a trusted multi-sector enterprise that drives sustainable growth through
                </p>
                <ul class="list-items">
                  <li><i class="tji-list"></i>Innovation</li>
                  <li><i class="tji-list"></i>Strategic Thinking</li>
                  <li><i class="tji-list"></i>Value-Driven Solutions</li>
                </ul>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="bg-shape-1">
        <img src="assets/images/shape/pattern-2.svg" alt="">
      </div>
      <div class="bg-shape-2">
        <img src="assets/images/shape/pattern-3.svg" alt="">
      </div>
    </section></section>
    <!-- end: About Section -->


    <!-- start: Testimonial Section --
    <section class="tj-testimonial-section-2 section-bottom-gap">
      <div class="container">
        <div class="row row-gap-3">
          <div class="col-lg-6 order-lg-2">
            <div class="testimonial-img-area wow fadeInUp" data-wow-delay=".3s">
              <div class="testimonial-img">
                <img src="assets/images/testimonial/testimonial-img.webp" alt="">
                <div class="sec-heading style-2">
                  <h2 class="sec-title title-anim">Hear from Our <span>Customer.</span></h2>
                </div>
              </div>
              <div class="box-area">
                <div class="rating-box wow fadeInUp" data-wow-delay=".5s">
                  <h2 class="title">4.9</h2>
                  <div class="rating-area">
                    <div class="star-ratings">
                      <div class="fill-ratings" style="width: 100%">
                        <span>★★★★★</span>
                      </div>
                      <div class="empty-ratings">
                        <span>★★★★★</span>
                      </div>
                    </div>
                  </div>
                  <span class="rating-text">(80+ Clients Reviews)</span>
                </div>
              </div>
            </div>
          </div>
          <div class="col-lg-6 order-lg-1">
            <div class="testimonial-wrapper wow fadeInUp" data-wow-delay=".5s">
              <div class="swiper testimonial-slider-2">
                <div class="swiper-wrapper">
                  <div class="swiper-slide">
                    <div class="testimonial-item">
                      <span class="quote-icon"><i class="tji-quote"></i></span>
                      <div class="desc">
                        <p>Working with Bexon has been a game-changer for our business. Their team's professionalism,
                          attention to detail, and innovative solutions have helped us streamline operations and achieve
                          our goals faster than we imagined. We truly feel like a valued partner. The results we’ve seen
                          after partnering.</p>
                      </div>
                      <div class="testimonial-author">
                        <div class="author-inner">
                          <div class="author-img">
                            <img src="assets/images/testimonial/client-1.webp" alt="">
                          </div>
                          <div class="author-header">
                            <h4 class="title">Guy Hawkins</h4>
                            <span class="designation">Co. Founder</span>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="swiper-slide">
                    <div class="testimonial-item">
                      <span class="quote-icon"><i class="tji-quote"></i></span>
                      <div class="desc">
                        <p>The results we’ve seen after partnering with Bexon are beyond our expectations. They not only
                          understood our vision but also brought new ideas to the table that have taken our business to
                          the next level. Their expertise and commitment to success make them a trusted.
                        </p>
                      </div>
                      <div class="testimonial-author">
                        <div class="author-inner">
                          <div class="author-img">
                            <img src="assets/images/testimonial/client-2.webp" alt="">
                          </div>
                          <div class="author-header">
                            <h4 class="title">Ralph Edwards</h4>
                            <span class="designation">Co. Founder</span>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="swiper-slide">
                    <div class="testimonial-item">
                      <span class="quote-icon"><i class="tji-quote"></i></span>
                      <div class="desc">
                        <p>We’ve been working with Bexonfor years, and they continue to deliver outstanding results.
                          Their team is proactive, responsive, and always goes the extra mile to ensure our needs are
                          met. They’ve become a key contributor to our growth and success that really help us"
                        </p>
                      </div>
                      <div class="testimonial-author">
                        <div class="author-inner">
                          <div class="author-img">
                            <img src="assets/images/testimonial/client-3.webp" alt="">
                          </div>
                          <div class="author-header">
                            <h4 class="title">Devon Lane</h4>
                            <span class="designation">Co. Founder</span>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="swiper-pagination-area"></div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!- end: Testimonial Section -->
  </main>

  <!-- start: Footer Section -->
<?php include("footer.php"); 
  ?>
  <!-- end: Footer Section -->

  <!-- JS here -->
  <script src="assets/js/jquery.min.js"></script>
  <script src="assets/js/bootstrap.bundle.min.js"></script>

  <script src="assets/js/gsap.min.js"></script>
  <script src="assets/js/gsap-scroll-to-plugin.min.js"></script>
  <script src="assets/js/gsap-scroll-trigger.min.js"></script>
  <script src="assets/js/gsap-split-text.min.js"></script>
  <script src="assets/js/smooth-scroll.min.js"></script>

  <script src="assets/js/jquery.nice-select.min.js"></script>
  <script src="assets/js/swiper.min.js"></script>
  <script src="assets/js/odometer.min.js"></script>
  <script src="assets/js/venobox.min.js"></script>
  <script src="assets/js/appear.min.js"></script>
  <script src="assets/js/wow.min.js"></script>
  <script src="assets/js/meanmenu.js"></script>
  <script src="assets/js/main.js"></script>
</body>

</html>